﻿using Microsoft.TeamFoundation.SourceControl.WebApi;
using Microsoft.VisualStudio.Services.Common;
using System;
using System.Text;

namespace GetGitRepos
{
    internal class Program
    {
        private static void Main(string[] args)
        {
            Console.CancelKeyPress += OnCancel;
            Console.WriteLine("This program gets the Git repositories in the given team project using REST API");
            Console.WriteLine("Press Control + C anytime to quit");
            Console.WriteLine();
            Console.WriteLine("Enter the url of your TFS server including collection name.");
            Console.WriteLine(
                "NOTE: Ensure that you have enterd https URL to TFS. This is necessary for connecting to TFS using username and password.");
            Console.WriteLine("E.g: https://tfs2015/tfs/defaultcollection");
            var tfsServerUrl = Console.ReadLine();
            Console.WriteLine("Please enter the username to connect");
            var userName = Console.ReadLine();
            Console.WriteLine("Please enter password");
            var password = GetConsolePassword();
            Console.WriteLine("Enter the team project name in which you want to fetch Git repositories");
            var projectName = Console.ReadLine();
            Console.WriteLine("Please wait...");
            var credentials = new VssBasicCredential(userName, password);

            GitHttpClient gitClient = new GitHttpClient(new Uri(tfsServerUrl), credentials);
            var gitRepositories = gitClient.GetRepositoriesAsync(projectName, true).Result;

            Console.WriteLine($"Done..Found {gitRepositories.Count} repositores");
            Console.WriteLine();

            Console.WriteLine("***Details***");
            Console.WriteLine();
            foreach (var gitRepository in gitRepositories)
            {
                Console.WriteLine($"Id: {gitRepository.Id}");
                Console.WriteLine($"Name: {gitRepository.Name}");
                Console.WriteLine($"RemoteUrl: {gitRepository.RemoteUrl}");
                Console.WriteLine();
            }

            Console.WriteLine("Press any key to exit");
            Console.ReadKey();
        }

        private static void OnCancel(object sender, ConsoleCancelEventArgs args)
        {
            Console.WriteLine("Operation terminated...Press any key to exit.");
            args.Cancel = true;
        }

        private static string GetConsolePassword()
        {
            StringBuilder sb = new StringBuilder();
            while (true)
            {
                ConsoleKeyInfo cki = Console.ReadKey(true);
                if (cki.Key == ConsoleKey.Enter)
                {
                    Console.WriteLine();
                    break;
                }

                if (cki.Key == ConsoleKey.Backspace)
                {
                    if (sb.Length > 0)
                    {
                        Console.Write("\b\0\b");
                        sb.Length--;
                    }
                    continue;
                }
                Console.Write("*");
                sb.Append(cki.KeyChar);
            }
            return sb.ToString();
        }
    }
}